#
# System5 resource file for the annotation subsystem
#
#**********************************************************

[Annotation]
	Version  = 10

# --- Billboard ---
# The following section sets up resources for annotation graphics, or
# the billboard as it is called. There are three groups of resources, 
# pointer, arrow, and text. Common resources are Color and EditColor which
# is specified as describef for menues above. At the time being, EditColor
# has no effect in some situations. Additional resources are Size for
# pointers and arrows, and Font for the text. The text also has a
# Position resource which is the x-y coordinate of the first text. Other
# texts are located just below the previous.
# Font names with spaces should have '-' instead of space.

[AnnBillboard]

	PointerColor     =   0 255   0
	TextColor        = 255 255   0
	ArrowColor       =   0 255 255
	BodymarkColor    = 255 255   0 
	ProbeColor       = 255   0   0
	ProbeEndColor    =   0 255   0
	SelectColor      = 255 255 255
	CaretColor       = 255 255 255

	PointerSize      = 20
	ArrowSize       = 5
	TextFont         = Times-New-Roman 28
	textPosition     = 200 200
        bMarkPosition    =  40  40
	ArrowPosition    = 300 300
	PointerPosition  = 300 300
	EditPosition     = 300 300

	textEditColor    = 150 150 255
	pointerEditColor = 150 150 255
	arrowEditColor   = 150 150 255
	vcrColor         = 190 190 190


# --- Application/Text Map ---
# This part map the various application names to M&A mode
# The name to the left is the internal scanner application
# name, (Which appear when doing the scanning)
# the name to the right is the annotation internal name.
#
# At the moment this is used to select which annotation-menu
# which should be selected during annotation.
# The name on the right is appended with 'Menu' to give the
# name of the annotation menu.
#   I.e.
#   	The Scanner application is named 'London'
#   	I want a separate annotation menu for it and makes the
#   	following line:
#   	    London = paris
#   	Then I must make a menu called parisMenu
#   	If I instead want to reuse an old menu call it
#   	for instance pvMenu, and the 'London' application
#   	will reuse the pvMenu
#
[annotAppMode]
   Abdomen	= Abdomen		# Abdomen.res
   Abdomen_1	= Abdomen_1
   Adult	= Adult			# Adult.res
   Adult_1	= Adult_1
   Ankle	= Ankle
   Breast	= Breast		# Breast.res
   Breast_1	= Breast_1
   Cardiac      = Cardiac		# Cardiac.res
   Carotid      = Carotid		# Carotid.res
   Carotid_1	= Carotid_1
   FetalEcho	= FetalEcho		# FetalHeart.res + FetalEcho.res
   FetalEcho_1  = FetalEcho_1
   Follicle     = Follicle		# Follicle.res
   Gyn          = Gyn			# Gyn.res
   Knee         = Knee
   LEA          = LEA			# LEA.res
   LEV          = LEV			# LEv.res
   NeoAbd       = NeoAbd		# NeoAbd.res
   NeoHead 	= NeoHead		# NeoHead.res
   NeoHead_1    = NeoHead_1
   OB1          = OB1			# OB1.res
   OB23         = OB23			# OB23.res
   OB23_1       = OB23_1
   PedAbd       = PedAbd		# PedAbd.res
   PedCard      = PedCard
   PedHip       = PedHip		# PedHip.res
   Pediatric    = Pediatric		# Ped.res + Pediatric.res
   Pediatric_1  = Pediatric_1
   Prostate     = Prostate
   Prostate_1   = Prostate_1		# Prostate.res
   Renal        = Renal			# Renal.res
   Scrotal      = Scrotal		# Scrotal.res
   Shoulder     = Shoulder		# MscSkel.res
   SmallParts   = SmallParts		# SmallParts.res
   SmallParts_1 = SmallParts_1
   TCD		= TCD			# Tc.res
   Thyroid      = Thyroid		# Thyroid.res
   Transplant   = Transplant
   UEA		= UEA			# UEA.res
   UEV		= UEV			# UEV.res
   Wrist	= Wrist

[AbdomenMenu]
    __restitle__     = Abdomen annotation texts
   predefinedEntry_1 = Sag
   predefinedEntry_3 = Trans
   predefinedEntry_5 = Right
   predefinedEntry_7 = Left
   predefinedEntry_9 = Prox
   predefinedEntry_11 = Mid
   predefinedEntry_13 = Dist
   predefinedEntry_15 = Anterior
   predefinedEntry_17 = Posterior
   predefinedEntry_19= Medial 
   predefinedEntry_21 = Lateral
   predefinedEntry_23 = Upper
   predefinedEntry_25 = Lower
   predefinedEntry_27 = LLD
   predefinedEntry_29 = Supine
   predefinedEntry_31 = RUQ
   predefinedEntry_33 = RLQ
   predefinedEntry_2 = Liver
   predefinedEntry_4 = Rt Lobe
   predefinedEntry_6 = Lt Lobe
   predefinedEntry_8 = Caudate
   predefinedEntry_10 = Gallbladder
   predefinedEntry_12 = CBD
   predefinedEntry_14 = Pancreas
   predefinedEntry_16 = Spleen
   predefinedEntry_18 = Aorta
   predefinedEntry_20 = IVC
   predefinedEntry_22 = Rt Kidney
   predefinedEntry_24 = Lt Kidney
   predefinedEntry_26 = Stomach
   predefinedEntry_28 = Fluid
   predefinedEntry_30 = Bowel
   predefinedEntry_32= LUQ
   predefinedEntry_34 = LLQ
   bodymarks   = ABD

# related to Abdo which was an old Vingmed annotation package
#    predefinedEntry_10     = Bladder
#    predefinedEntry_13     = Hepatic
#    predefinedEntry_14     = Portal
#    predefinedEntry_15     = Renal
#    predefinedEntry_16     = Artery
#    predefinedEntry_17     = Vein
#    predefinedEntry_18     = Stenosis
# related to AortoIliac which was an old Vingmed annotation package
#    predefinedEntry_1     = Aorta
#    predefinedEntry_2     = IVC
#    predefinedEntry_3     = Coeliac Trunk
#    predefinedEntry_4     = Sup Mesenteric
#    predefinedEntry_5     = Renal
#    predefinedEntry_6     = Com Iliac
#    predefinedEntry_7     = Ext Iliac
#    predefinedEntry_8     = Int Iliac
#    predefinedEntry_9     = Artery
#    predefinedEntry_10    = Vein
#    predefinedEntry_11    = Right
#    predefinedEntry_12    = Left
#    predefinedEntry_13    = Stenosis
  
[Abdomen_1Menu]
    __restitle__     = Abdomen 1 annotation texts
   predefinedEntry_1 = Sag  
   predefinedEntry_3 = Trans
   predefinedEntry_5 = Right 
   predefinedEntry_7 = Left  
   predefinedEntry_9 = Prox 
   predefinedEntry_11 = Mid  
   predefinedEntry_13 = Dist 
   predefinedEntry_15 = Upper
   predefinedEntry_17= Lower
   predefinedEntry_19 = Anast
   predefinedEntry_21 = TIPS
   predefinedEntry_2 = Portal Vein
   predefinedEntry_4 = Hep A
   predefinedEntry_6 = Hep V
   predefinedEntry_8 = SMA
   predefinedEntry_10 = GDA
   predefinedEntry_12 = SMV
   predefinedEntry_14 = Celiac
   predefinedEntry_16 = IMA
   predefinedEntry_18 = Renal A
   predefinedEntry_20 = Renal V
   predefinedEntry_22 = Splenic V
   bodymarks   = ABD
   
[AdultMenu]
    __restitle__     = Adult annotation texts
   predefinedEntry_1 = MV
   predefinedEntry_2 = Ventricle
   predefinedEntry_3 = AoV
   predefinedEntry_4 = TV
   predefinedEntry_5 = PV
   predefinedEntry_6 = Arch
   predefinedEntry_7 = IVS
   predefinedEntry_8 = Atrium
   predefinedEntry_9 = Right
   predefinedEntry_10 = Left
   predefinedEntry_11 = IAS
   predefinedEntry_12 = Chordae Tendinae
   predefinedEntry_13 = SCV
   predefinedEntry_14 = IVC
   predefinedEntry_15 = PV
   predefinedEntry_16 = Base
   predefinedEntry_17 = Apex
   predefinedEntry_18 = Pericardium
   predefinedEntry_19 = Aorta
   predefinedEntry_20 = Moderator Band
   predefinedEntry_21 = PLAX
   predefinedEntry_22 = Endocardium
   predefinedEntry_23 = Anterior
   predefinedEntry_24 = Posterior
   predefinedEntry_25 = Inferior
   predefinedEntry_26 = Cusp
   predefinedEntry_27 = CA
   predefinedEntry_28 = Myocardium
   predefinedEntry_29 = PSAX
   predefinedEntry_30 = Subcostal
   bodymarks   = CARD
   
[Adult_1Menu]
    __restitle__     = Adult 1 annotation texts
   predefinedEntry_1 = Apcial
   predefinedEntry_2 = Pulmonary Artery
   predefinedEntry_3 = Posterior Wall
   predefinedEntry_4 = Papillary Muscle
   predefinedEntry_5 = Descending Aorta
   predefinedEntry_6 = Prostethic Valve
   predefinedEntry_7 = Pacemaker Wire
   bodymarks   = CARD
   
[AnkleMenu]
    __restitle__     = Ankle annotation texts
   predefinedEntry_1 = Right
   predefinedEntry_3 = Left 
   predefinedEntry_5 = Sag  
   predefinedEntry_7 = Trans
   predefinedEntry_9 = Prox  
   predefinedEntry_11 = Mid   
   predefinedEntry_13 = Dist 
   predefinedEntry_15 = Upper 
   predefinedEntry_17 = Lower 
   predefinedEntry_19 = Anterior 
   predefinedEntry_21 = Posterior  
   predefinedEntry_2 = Medial Malleolus
   predefinedEntry_4 = Peroneous Brevis
   predefinedEntry_6 = Peroneous Longus
   predefinedEntry_8 = Achilles Tendon
   predefinedEntry_10 = Talus
   predefinedEntry_12 = Calcaneous
   predefinedEntry_14 = Plantar Fascia
   predefinedEntry_16 = Tendon
   predefinedEntry_18 = Flexor Digitorum L
   predefinedEntry_20 = Ligament
   predefinedEntry_22 = Flexor Hallucis Longus
   bodymarks          = MSCL

[BreastMenu]
    __restitle__        	  = Breast annotation texts
    predefinedEntry_1     = Right
    predefinedEntry_2     = Left
    predefinedEntry_3     = Medial
    predefinedEntry_4     = Lateral
    predefinedEntry_5     = Superior
    predefinedEntry_6     = Inferior
    predefinedEntry_7     = Axilla
    predefinedEntry_8     = Post Aspiration
    predefinedEntry_9     = O'Clock
    bodymarks             = SMLP

[Breast_1Menu]
    __restitle__     = Breast annotation texts
   predefinedEntry_1 = O'Clock
   predefinedEntry_2 = Right 
   predefinedEntry_3 = Left  
   predefinedEntry_4 = Sag  
   predefinedEntry_5 = Trans
   predefinedEntry_6 = Prox 
   predefinedEntry_7 = Mid  
   predefinedEntry_8 = Dist 
   predefinedEntry_9 = Upper
   predefinedEntry_10 = Lower
   predefinedEntry_11 = Nipple
   predefinedEntry_12 = Lymph Node
   predefinedEntry_13 = Breast
   predefinedEntry_14 = Radial
   predefinedEntry_15 = Anti-Radial
   predefinedEntry_16 = Axillary Tail
   predefinedEntry_17 = Area of palp
   bodymarks   = SMLP

[CardiacMenu]
    __restitle__	= Cardiac annotation texts
    predefinedEntry_1	= Syst
    predefinedEntry_2	= Diast
    predefinedEntry_3	= IAS
    predefinedEntry_4	= RVOT
    predefinedEntry_5	= IVS
    predefinedEntry_6	= LVOT
    predefinedEntry_7	= PA
    predefinedEntry_8	= AO
    predefinedEntry_9	= RA
    predefinedEntry_10	= LA
    predefinedEntry_11	= RV
    predefinedEntry_12	= LV
    predefinedEntry_13	= PV
    predefinedEntry_14	= TV
    predefinedEntry_15	= AOV
    predefinedEntry_16	= MV
    bodymarks           = CARD

[CarotidMenu]
    __restitle__     = Carotid annotation texts
   predefinedEntry_1 = Right
   predefinedEntry_3 = Left 
   predefinedEntry_5 = Prox  
   predefinedEntry_7 = Mid   
   predefinedEntry_9 = Dist 
   predefinedEntry_11 = CCA
   predefinedEntry_13 = Bulb
   predefinedEntry_15 = ICA
   predefinedEntry_17 = ECA
   predefinedEntry_19 = Vert
   predefinedEntry_21 = Subc
   predefinedEntry_23 = Innom
   predefinedEntry_25 = Stenosis
   predefinedEntry_27 = Graft
   predefinedEntry_29 = Anast
   predefinedEntry_31 = Bifurcation
   predefinedEntry_2 = Sag 
   predefinedEntry_4 = Trans
   predefinedEntry_6 = Anterior  
   predefinedEntry_8 = Posterior 
   predefinedEntry_10 = Lateral   
   predefinedEntry_12 = Upper 
   predefinedEntry_14 = Lower 
   predefinedEntry_16 = Thyroid
   predefinedEntry_18 = Artery
   predefinedEntry_20 = Vein  
   predefinedEntry_22 = IJV
   predefinedEntry_24 = EJV
   predefinedEntry_26 = Vert V
   predefinedEntry_28 = Ao Arch
   predefinedEntry_30 = Aneurysm
   predefinedEntry_32 = SupTh
   bodymarks   = VASC

[Carotid_1Menu]
    __restitle__     = Carotid annotation texts
   predefinedEntry_1 = Right
   predefinedEntry_2 = Left 
   predefinedEntry_3 = Sag  
   predefinedEntry_4 = Trans
   predefinedEntry_5 = Prox  
   predefinedEntry_6 = Mid   
   predefinedEntry_7 = Dist  
   predefinedEntry_8 = Upper 
   predefinedEntry_9 = Aneurysm
   predefinedEntry_10 = Lower 
   predefinedEntry_11 = Anterior  
   predefinedEntry_12 = Posterior 
   predefinedEntry_13 = Lateral   
   predefinedEntry_14 = Thyroid
   predefinedEntry_15 = IJV
   predefinedEntry_16 = Bifurcation
   predefinedEntry_17 = CCA
   predefinedEntry_18 = ICA
   predefinedEntry_19 = Bulb
   predefinedEntry_20 = ECA
   predefinedEntry_21 = Vert
   predefinedEntry_22 = Subc
   predefinedEntry_23 = Innom
   predefinedEntry_24 = Sag   
   predefinedEntry_25 = Trans 
   predefinedEntry_26 = Artery
   predefinedEntry_27 = Vein  
   predefinedEntry_28 = Stenosis
   predefinedEntry_29 = Graft
   predefinedEntry_30 = Anast
   predefinedEntry_31 = Thyro
   predefinedEntry_32 = SupTh
   predefinedEntry_33 = Ao Arch
   predefinedEntry_34 = EJV
   predefinedEntry_35 = Muscle
   predefinedEntry_36 = Vert V
   bodymarks   = VASC

[FetalEchoMenu]
    __restitle__     = Fetal annotation texts
   predefinedEntry_1 = LAX
   predefinedEntry_3 = Apical 4 Chamber
   predefinedEntry_5 = LV 
   predefinedEntry_7 = LA
   predefinedEntry_9 = LVOT 
   predefinedEntry_11 = MV
   predefinedEntry_13 = AV
   predefinedEntry_15 = Pulm Veins
   predefinedEntry_17 = 4 CH
   predefinedEntry_19 = Intravent Sept
   predefinedEntry_21 = AA
   predefinedEntry_23 = DAo
   predefinedEntry_25 = Ductus Arch
   predefinedEntry_27 = Ductus
   predefinedEntry_29 = Foram Flap
   predefinedEntry_2 = SAX
   predefinedEntry_4 = 5 Chamber
   predefinedEntry_6 = RV
   predefinedEntry_8 = RA
   predefinedEntry_10= RVOT
   predefinedEntry_12 = TV
   predefinedEntry_14= Pulm Valve
   predefinedEntry_16 = MPA
   predefinedEntry_18 = Rt Pulm A
   predefinedEntry_20 = Lt Pulm A
   predefinedEntry_22 = IVC
   predefinedEntry_24 = SVC
   predefinedEntry_26 = Eust Valve
   predefinedEntry_28 = Mod Band
   predefinedEntry_30 = Rt Atrial Append
   bodymarks   = OB

[FetalEcho_1Menu]
    __restitle__     = Fetal Echo annotation texts
   predefinedEntry_1 = Right 
   predefinedEntry_3 = Left  
   predefinedEntry_5 = Sag  
   predefinedEntry_7 = Trans
   predefinedEntry_9 = Prox 
   predefinedEntry_11 = Mid  
   predefinedEntry_13 = Dist 
   predefinedEntry_15 = Upper 
   predefinedEntry_17 = Lower 
   predefinedEntry_19 = Anterior 
   predefinedEntry_21 = Posterior
   predefinedEntry_23 = Spine
   predefinedEntry_2 = PDA
   predefinedEntry_4 = Superior
   predefinedEntry_6 = Inferior
   predefinedEntry_8 = AAo
   predefinedEntry_10 = Carotid
   predefinedEntry_12 = Innominate
   predefinedEntry_14 = Subclavian Artery
   predefinedEntry_16 = Stomach
   predefinedEntry_18 = Formen Ovale
   predefinedEntry_20 = RCA
   predefinedEntry_22 = Venous Duct
   bodymarks   = TWIN

#    predefinedEntry_1	= Gestation Sac
#    predefinedEntry_2	= Embryo
#    predefinedEntry_3	= Yolk Sac
#    predefinedEntry_4	= Head
#    predefinedEntry_5	= Abdomen
#    predefinedEntry_6	= Femur
#    predefinedEntry_7	= Spine
#    predefinedEntry_8	= Heart
#    predefinedEntry_9	= Stomach
#    predefinedEntry_10	= Kidney
#    predefinedEntry_11	= Bladder
#    predefinedEntry_12	= Placenta
#    predefinedEntry_13	= Umb Cord

[FollicleMenu]
    __restitle__     =  Follicle annotation texts
   predefinedEntry_1 = Right 
   predefinedEntry_3 = Left  
   predefinedEntry_5 = Sag   
   predefinedEntry_7 = Trans 
   predefinedEntry_9 = Anterior 
   predefinedEntry_11 = Posterior
   predefinedEntry_13 = Prox 
   predefinedEntry_15 = Mid  
   predefinedEntry_17 = Dist 
   predefinedEntry_19 = Medial 
   predefinedEntry_21 = Lateral
   predefinedEntry_23 = Upper 
   predefinedEntry_25 = Lower 
   predefinedEntry_27 = Rt Kidney
   predefinedEntry_29 = Free Fluid
   predefinedEntry_31 = RUQ
   predefinedEntry_33 = RLQ
   predefinedEntry_2 = Uterus
   predefinedEntry_4 = Endometrium
   predefinedEntry_6 = Cul De Sac
   predefinedEntry_8 = Vagina
   predefinedEntry_10 = Cervix
   predefinedEntry_12 = Rt Adnexa
   predefinedEntry_14 = Lt Adnexa
   predefinedEntry_16 = Rt Ovary 
   predefinedEntry_18 = Lt Ovary 
   predefinedEntry_20 = Corp Luteum
   predefinedEntry_22 = Bladder
   predefinedEntry_24 = Dominant Follicle
   predefinedEntry_26 = Ovum
   predefinedEntry_28 = Lt Kidney
   predefinedEntry_30 = Bowel
   predefinedEntry_32 = LUQ
   predefinedEntry_34 = LLQ
   bodymarks   = GYN


[GynMenu]
    __restitle__     = Gynecology annotation texts
   predefinedEntry_1 = Right 
   predefinedEntry_3 = Left  
   predefinedEntry_5 = Sag  
   predefinedEntry_7 = Trans
   predefinedEntry_9 = Anterior 
   predefinedEntry_11 = Posterior
   predefinedEntry_13 = Prox  
   predefinedEntry_15 = Mid   
   predefinedEntry_17 = Dist  
   predefinedEntry_19 = Medial 
   predefinedEntry_21 = Lateral 
   predefinedEntry_23 = Upper
   predefinedEntry_25 = Lower
   predefinedEntry_27 = RUQ  
   predefinedEntry_29 = RLQ 
   predefinedEntry_31 = Rt Kidney 
   predefinedEntry_2 = Uterus
   predefinedEntry_4 = Endometrium
   predefinedEntry_6 = Cul De Sac
   predefinedEntry_8 = Vagina
   predefinedEntry_10 = Cervix
   predefinedEntry_12 = Rt Adnexa 
   predefinedEntry_14 = Lt Adnexa 
   predefinedEntry_16 = Rt Ovary
   predefinedEntry_18 = Lt Ovary
   predefinedEntry_20 = Corp Luteum
   predefinedEntry_22 = Bladder
   predefinedEntry_24 = Free Fluid
   predefinedEntry_26 = Bowel
   predefinedEntry_28 = LUQ
   predefinedEntry_30 = LLQ
   predefinedEntry_32 = Lt Kidney 
   bodymarks   = GYN

#    predefinedEntry_5	= Fallopian Tube
#    predefinedEntry_7	= Ureter
#    predefinedEntry_9	= Artery
#    predefinedEntry_10	= Vein

[KneeMenu]
    __restitle__     =  Knee annotation texts
   predefinedEntry_1 = Right
   predefinedEntry_3 = Left 
   predefinedEntry_5 = Sag  
   predefinedEntry_7 = Trans
   predefinedEntry_9 = Prox 
   predefinedEntry_11 = Mid  
   predefinedEntry_13 = Dist 
   predefinedEntry_15 = Medial 
   predefinedEntry_17 = Lateral
   predefinedEntry_19 = Upper
   predefinedEntry_21 = Lower
   predefinedEntry_23 = Anterior    
   predefinedEntry_25 = Posterior
   predefinedEntry_27 = Cartilage
   predefinedEntry_2 = Patella
   predefinedEntry_4 = Bursa
   predefinedEntry_6 = MCL
   predefinedEntry_8 = LCL
   predefinedEntry_10 = Pes
   predefinedEntry_12 = Tibia
   predefinedEntry_14 = Meniscus
   predefinedEntry_16 = QT
   predefinedEntry_18 = PT
   predefinedEntry_20 = BF
   predefinedEntry_22 = Condyl
   predefinedEntry_24 = ACL
   predefinedEntry_26 = PCL
   predefinedEntry_28 = Gastroc
   bodymarks          = MSCL
   
[LEAMenu]
    __restitle__     =  LEA annotation texts
   predefinedEntry_1 = Right
   predefinedEntry_3 = Left 
   predefinedEntry_5 = Prox  
   predefinedEntry_7 = Mid   
   predefinedEntry_9 = Dist
   predefinedEntry_11 = CIA
   predefinedEntry_13 = EIA
   predefinedEntry_15 = CFA
   predefinedEntry_17 = Profunda
   predefinedEntry_19 = SFA
   predefinedEntry_21 = Pop
   predefinedEntry_23 = PTA 
   predefinedEntry_25 = DPA
   predefinedEntry_27 = Peron
   predefinedEntry_2 = Sag  
   predefinedEntry_4 = Trans 
   predefinedEntry_6 = Upper
   predefinedEntry_8 = Lower 
   predefinedEntry_10 = Artery
   predefinedEntry_12 = Vein
   predefinedEntry_14 = Aorta
   predefinedEntry_16 = Pop Fossa
   predefinedEntry_18 = Stenosis
   predefinedEntry_20 = Graft
   predefinedEntry_22 = Anast
   predefinedEntry_24 = Aneurysm
   predefinedEntry_26 = Bruit
   predefinedEntry_28 = Digital
   predefinedEntry_27 = Med TA 
   predefinedEntry_28 = Lat TA 
   predefinedEntry_29 = Med PA
   predefinedEntry_30 = Lat PA
   bodymarks = VASC


# related to leg which was an old Vingmed annotation package
#    predefinedEntry_1     = Com Femoral
#    predefinedEntry_2     = Sup Femoral
#    predefinedEntry_4     = Popliteal
#    predefinedEntry_5     = Long Saphenous
#    predefinedEntry_6     = Short Saphenous
#    predefinedEntry_7     = Post Tibial
#    predefinedEntry_9     = Ant Tibial
#    predefinedEntry_10    = Dorsalis Pedis
#    predefinedEntry_13    = Stenosis

[LEVMenu]
    __restitle__     = LEV annotation texts
   predefinedEntry_1 = w/Comp  
   predefinedEntry_3 = Augment
   predefinedEntry_5 = Sag   
   predefinedEntry_7 = Trans 
   predefinedEntry_9 = EIV
   predefinedEntry_11 = FV
   predefinedEntry_13 = CFV
   predefinedEntry_15 = DFV
   predefinedEntry_17 = GSV
   predefinedEntry_19 = PopV 
   predefinedEntry_21 = PTV
   predefinedEntry_23 = ATV
   predefinedEntry_25 = Peron
   predefinedEntry_27 = Graft
   predefinedEntry_29 = Anast
   predefinedEntry_31 = Stenosis
   predefinedEntry_33 = Aneurysm
   predefinedEntry_2 = Right
   predefinedEntry_4 = Left
   predefinedEntry_6 = Prox  
   predefinedEntry_8 = Mid   
   predefinedEntry_10 = Dist
   predefinedEntry_12 = Upper 
   predefinedEntry_14 = Lower 
   predefinedEntry_16 = Artery
   predefinedEntry_18 = Vein 
   predefinedEntry_20 = IVC
   predefinedEntry_22 = CIA
   predefinedEntry_24 = LSV
   predefinedEntry_26 = Soleal
   predefinedEntry_28 = Pop Fossa
   predefinedEntry_30 = Tibia 
   predefinedEntry_32= Fibula 
   bodymarks = VASC

[NeoAbdMenu]
    __restitle__     =  NeoAbd annotation texts
   predefinedEntry_1 = Right
   predefinedEntry_3 = Left 
   predefinedEntry_5 = Sag   
   predefinedEntry_7 = Trans 
   predefinedEntry_9 = Prox
   predefinedEntry_11 = Mid 
   predefinedEntry_13 = Dist
   predefinedEntry_15 = Upper
   predefinedEntry_17 = Lower
   predefinedEntry_19 = Supine
   predefinedEntry_21 = LLD 
   predefinedEntry_23 = RUQ 
   predefinedEntry_25 = RLQ
   predefinedEntry_27 = LUQ 
   predefinedEntry_29 = LLQ 
   predefinedEntry_31 = Fluid
   predefinedEntry_33 = Bowel
   predefinedEntry_2 = Liver
   predefinedEntry_4 = Caudate
   predefinedEntry_6 = Rt Lobe 
   predefinedEntry_8 = Lt Lobe
   predefinedEntry_10 = Gallbladder
   predefinedEntry_12 = CBD
   predefinedEntry_14 = Pancreas
   predefinedEntry_16 = Rt Kidney 
   predefinedEntry_18 = Lt Kidney
   predefinedEntry_20 = Adrenal
   predefinedEntry_22 = Spleen
   predefinedEntry_24 = Aorta 
   predefinedEntry_26 = IVC
   predefinedEntry_28 = Bladder
   predefinedEntry_30 = Duodenum
   predefinedEntry_32 = Stomach
   predefinedEntry_34 = Pyloris
   bodymarks          = PED

[NeoHeadMenu]
    __restitle__	  = Neonatal annotation texts
    predefinedEntry_1     = Cerebellum
    predefinedEntry_2     = Thalamus
    predefinedEntry_3     = ChoroidPlexus
    predefinedEntry_4     = LatVentricle
    predefinedEntry_5     = 4thVentricle
    predefinedEntry_6     = 3rdVentricle
    predefinedEntry_7     = Basilar
    predefinedEntry_8     = Cerebral
    predefinedEntry_9     = Gallen
    predefinedEntry_10    = Ant
    predefinedEntry_11    = Middle
    predefinedEntry_12    = Post
    predefinedEntry_13    = Artery
    predefinedEntry_14    = Vein
    predefinedEntry_15    = Right
    predefinedEntry_16    = Left
    bodymarks             = PED

[NeoHead_1Menu]
    __restitle__     =  NeoHead annotation texts
   predefinedEntry_1 = Right
   predefinedEntry_3 = Left 
   predefinedEntry_5 = Sag  
   predefinedEntry_7 = Trans
   predefinedEntry_9 = Anterior  
   predefinedEntry_11 = Posterior 
   predefinedEntry_13 = Prox
   predefinedEntry_15 = Mid 
   predefinedEntry_17 = Dist
   predefinedEntry_19 = Trigone
   predefinedEntry_21 = Mid Bodies 
   predefinedEntry_2 = Frontal Horns
   predefinedEntry_4 = Coronal 
   predefinedEntry_6 = Germinal Matrix
   predefinedEntry_8 = Thalami
   predefinedEntry_10 = Cerebellum
   predefinedEntry_12 = Ventricle
   predefinedEntry_14 = Choroid Plexus
   predefinedEntry_16 = CSP
   predefinedEntry_18 = Sylvian Fissure
   predefinedEntry_20 = Axial     
   bodymarks          = PED

[OB1Menu]
    __restitle__     =  Obstetric 1 annotation texts
   predefinedEntry_1 = Sag   
   predefinedEntry_3 = Trans
   predefinedEntry_5 = Right 
   predefinedEntry_7 = Left 
   predefinedEntry_9 = Anterior 
   predefinedEntry_11 = Posterior 
   predefinedEntry_13 = Medial 
   predefinedEntry_15 = Lateral
   predefinedEntry_17 = Prox    
   predefinedEntry_19 = Mid     
   predefinedEntry_21= Dist    
   predefinedEntry_23 = Upper 
   predefinedEntry_25 = Lower 
   predefinedEntry_27 = Rt Adnexa
   predefinedEntry_29 = Lt Adnexa
   predefinedEntry_31 = Rt Ovary 
   predefinedEntry_33 = Lt Ovary 
   predefinedEntry_2 = Uterus
   predefinedEntry_4 = Endometrium
   predefinedEntry_6 = Cul De Sac
   predefinedEntry_8 = Cervix
   predefinedEntry_10 = Corp Luteum
   predefinedEntry_12 = Amnion
   predefinedEntry_14 = Placenta
   predefinedEntry_16 = Gest Sac
   predefinedEntry_18 = Yolk Sac
   predefinedEntry_20 = NT
   predefinedEntry_22 = Chorion
   predefinedEntry_24 = Rt Kidney 
   predefinedEntry_26 = Lt Kidney 
   predefinedEntry_28 = Fluid
   predefinedEntry_30 = Vagina
   predefinedEntry_32= Bowel
   bodymarks          = OB
   
[OB23Menu]
    __restitle__     =  Obstetric 2 annotation texts
   predefinedEntry_1 = Sag  
   predefinedEntry_3 = Trans 
   predefinedEntry_5 = Right
   predefinedEntry_7 = Left 
   predefinedEntry_9 = Cephalic   
   predefinedEntry_11 = Breech     
   predefinedEntry_13= Spine
   predefinedEntry_15 = 4 CH Heart
   predefinedEntry_17 = Placenta
   predefinedEntry_19 = Cord Insert
   predefinedEntry_21 = 3 V Cord
   predefinedEntry_23 = Bladder
   predefinedEntry_25 = Stomach
   predefinedEntry_27 = Diaphragm
   predefinedEntry_29 = Kidneys
   predefinedEntry_31 = Male
   predefinedEntry_2 = Lips/Nose
   predefinedEntry_4 = Tib/Fib
   predefinedEntry_6 = Radius/Ulna
   predefinedEntry_8 = Humerus
   predefinedEntry_10 = Femur
   predefinedEntry_12 = Hand
   predefinedEntry_14 = Foot
   predefinedEntry_16 = Digits
   predefinedEntry_18 = Cerebellum
   predefinedEntry_20 = Nuchal Fold
   predefinedEntry_22 = Ventricle
   predefinedEntry_24 = Cavum Sept P
   predefinedEntry_26 = Cist Magna
   predefinedEntry_28 = Falx Cere
   predefinedEntry_30 = Chor Plexus
   predefinedEntry_32= Female 
   bodymarks          = OB

# related to fetal which was an old Vingmed annotation package
#    predefinedEntry_1	= Gestation Sac
#    predefinedEntry_2	= Embryo
#    predefinedEntry_3	= Yolk Sac
#    predefinedEntry_4	= Head
#    predefinedEntry_5	= Abdomen
#    predefinedEntry_6	= Femur
#    predefinedEntry_7	= Spine
#    predefinedEntry_8	= Heart
#    predefinedEntry_9	= Stomach
#    predefinedEntry_10	= Kidney
#    predefinedEntry_11	= Bladder
#    predefinedEntry_12	= Placenta
#    predefinedEntry_13	= Umb Cord
#    predefinedEntry_14	= Right
#    predefinedEntry_15	= Left

[OB23_1Menu]
    __restitle__     =  Obstetric 3 annotation texts
   predefinedEntry_1 = Sag   
   predefinedEntry_3 = Trans
   predefinedEntry_5 = Right
   predefinedEntry_7 = Left 
   predefinedEntry_9 = Rt Adnexa
   predefinedEntry_11 = Lt Adnexa
   predefinedEntry_13 = Rt Ovary 
   predefinedEntry_15 = Lt Ovary 
   predefinedEntry_2 = Liver
   predefinedEntry_4 = Gallbladder
   predefinedEntry_6 = Vena Cava
   predefinedEntry_8 = Aorta
   predefinedEntry_10 = Ao Arch
   predefinedEntry_12 = Venous Duct
   predefinedEntry_14 = Atria
   predefinedEntry_16 = Umb Cord
   predefinedEntry_17 = MCA
   bodymarks          = TWIN
   
[PedAbdMenu]
    __restitle__     = PedAbd annotation texts
   predefinedEntry_1 = Right
   predefinedEntry_3 = Left 
   predefinedEntry_5 = Sag  
   predefinedEntry_7 = Trans
   predefinedEntry_9 = Prox 
   predefinedEntry_11 = Mid  
   predefinedEntry_13 = Dist 
   predefinedEntry_15 = Upper 
   predefinedEntry_17 = Lower 
   predefinedEntry_19 = Supine 
   predefinedEntry_21 = LLD  
   predefinedEntry_23 = RUQ 
   predefinedEntry_25 = LUQ 
   predefinedEntry_27 = RLQ 
   predefinedEntry_29 = LLQ 
   predefinedEntry_31 = Fluid
   predefinedEntry_33 = Bowel 
   predefinedEntry_2 = Liver 
   predefinedEntry_4 = Caudate
   predefinedEntry_6 = Rt Lobe 
   predefinedEntry_8 = Lt Lobe 
   predefinedEntry_10 = Gallbladder
   predefinedEntry_12 = CBD
   predefinedEntry_14 = Pancreas
   predefinedEntry_16 = Spleen
   predefinedEntry_18 = Rt Kidney
   predefinedEntry_20 = Lt Kidney
   predefinedEntry_22 = Adrenal
   predefinedEntry_24 = Aorta
   predefinedEntry_26 = IVC
   predefinedEntry_28 = Duodenum
   predefinedEntry_30 = Bladder
   predefinedEntry_32 = Stomach
   predefinedEntry_34 = Pyloris
   bodymarks          = PED

[PedCardMenu]
    __restitle__	= Pediatric Cardiology annotation texts
    predefinedEntry_1	= Syst
    predefinedEntry_2	= Diast
    predefinedEntry_3	= IAS
    predefinedEntry_4	= RVOT
    predefinedEntry_5	= IVS
    predefinedEntry_6	= LVOT
    predefinedEntry_7	= PA
    predefinedEntry_8	= AO
    predefinedEntry_9	= RA
    predefinedEntry_10	= LA
    predefinedEntry_11	= RV
    predefinedEntry_12	= LV
    predefinedEntry_13	= PV
    predefinedEntry_14	= TV
    predefinedEntry_15	= AOV
    predefinedEntry_16	= MV
    predefinedEntry_17	= ASD
    predefinedEntry_18	= VSD
    predefinedEntry_19	= PDA
    predefinedEntry_20	= SVC
    predefinedEntry_21	= IVC
    predefinedEntry_22	= RAA
    predefinedEntry_23	= LAA
    predefinedEntry_24	= LPA
    predefinedEntry_25	= RPA
    predefinedEntry_26	= MPA
    bodymarks           = CARD

[PedHipMenu]                         
    __restitle__     = PedHip annotation texts
   predefinedEntry_1 = Right 
   predefinedEntry_3 = Left  
   predefinedEntry_5 = Sag   
   predefinedEntry_7 = Trans 
   predefinedEntry_9 = Prox   
   predefinedEntry_11 = Dist 
   predefinedEntry_13 = Medial 
   predefinedEntry_15 = Lateral
   predefinedEntry_17 = Anterior 
   predefinedEntry_19 = Posterior
   predefinedEntry_21 = Upper 
   predefinedEntry_23 = Lower
   predefinedEntry_25 = Cephalic 
   predefinedEntry_2 = Lig Teres
   predefinedEntry_4  = Coronal
   predefinedEntry_6 = Trochanter
   predefinedEntry_8 = Femur
   predefinedEntry_10 = Fem Shaft
   predefinedEntry_12 = Acetabulum
   predefinedEntry_14 = Gluteus Minimus
   predefinedEntry_16 = Fem Head
   predefinedEntry_18 = Labrum Acetabulare
   predefinedEntry_20 = Epiphysis
   predefinedEntry_22 = Gluteus Medius
   predefinedEntry_24 = Ilium
   predefinedEntry_26 = Caudal  
   bodymarks          = PED

[PediatricMenu]
    __restitle__     = Pediatric annotation texts
   predefinedEntry_1 = Right
   predefinedEntry_3 = Left 
   predefinedEntry_5 = Sag   
   predefinedEntry_7 = Trans
   predefinedEntry_9 = Medial  
   predefinedEntry_11 = Lateral 
   predefinedEntry_13 = Anterior 
   predefinedEntry_15 = Posterior
   predefinedEntry_17 = Inferior 
   predefinedEntry_19 = Superior 
   predefinedEntry_21 = PLAX
   predefinedEntry_23 = PSAX
   predefinedEntry_25 = Subcostal 
   predefinedEntry_27 = Atrium
   predefinedEntry_29 = Ventricle
   predefinedEntry_31 = Base
   predefinedEntry_33 = Apex
   predefinedEntry_2 = AoV
   predefinedEntry_4 = TV
   predefinedEntry_6 = PV
   predefinedEntry_8 = Arch
   predefinedEntry_10 = IVS
   predefinedEntry_12 = MV
   predefinedEntry_14 = IAS
   predefinedEntry_16 = Chordae Tendinae
   predefinedEntry_18 = SCV
   predefinedEntry_20 = IVC
   predefinedEntry_22 = PV
   predefinedEntry_24 = Aorta
   predefinedEntry_26 = CA
   predefinedEntry_28 = Endocardium 
   predefinedEntry_30 = Pericardium 
   predefinedEntry_32 = Myocardium 
   predefinedEntry_34 = Medial 
   bodymarks          = CARD

[Pediatric_1Menu]
    __restitle__     = Pediatric annotation texts
   predefinedEntry_1 = Right 
   predefinedEntry_2 = Left  
   predefinedEntry_3 = Sag   
   predefinedEntry_4 = Trans 
   predefinedEntry_5 = Posterior Wall
   predefinedEntry_6 = Papillary Muscle
   predefinedEntry_7 = Descending Aorta
   predefinedEntry_8 = Prostethic Valve
   predefinedEntry_9 = Pacemaker Wire
   predefinedEntry_10 = Apical
   predefinedEntry_11 = Pulm A
   bodymarks          = CARD

[ProstateMenu]
    __restitle__  	= Prostate annotation texts
    predefinedEntry_1	= Prostate
    predefinedEntry_2	= Central Zone
    predefinedEntry_3	= Transition Zone
    predefinedEntry_4	= Peripheral Zone
    predefinedEntry_5	= Urethra
    predefinedEntry_6	= Bladder
    predefinedEntry_7	= Rectum
    predefinedEntry_8	= Seminal Vesicle
    predefinedEntry_9	= Vas Deferens
    predefinedEntry_10	= Ejaculatory Ducts
    predefinedEntry_11	= Verumontanum
    bodymarks           = URO

#    predefinedEntry_9	= Artery
#    predefinedEntry_10	= Vein
   
[Prostate_1Menu]
    __restitle__     = Prostate annotation texts
   predefinedEntry_1 = Right  
   predefinedEntry_2 = Left   
   predefinedEntry_3 = Sag  
   predefinedEntry_4 = Trans
   predefinedEntry_5 = Prox 
   predefinedEntry_6 = Mid  
   predefinedEntry_7 = Dist 
   predefinedEntry_8 = Upper
   predefinedEntry_9 = Base
   predefinedEntry_10 = Lower
   predefinedEntry_11 = Periph Zone
   predefinedEntry_12 = Sem Vesicle
   predefinedEntry_13 = Bladder
   predefinedEntry_14 = Rectum
   predefinedEntry_15 = Transitional Zone
   predefinedEntry_16 = Fibromusc Stroma
   predefinedEntry_17 = Central Gland
   predefinedEntry_18 = Urethera
   predefinedEntry_19 = Apex
   bodymarks          = URO
   
[RenalMenu]
    __restitle__     = Renal annotation texts
   predefinedEntry_1 = Sag  
   predefinedEntry_3 = Trans 
   predefinedEntry_5 = Right
   predefinedEntry_7 = Left
   predefinedEntry_9 = Anterior  
   predefinedEntry_11 = Posterior
   predefinedEntry_13 = Medial  
   predefinedEntry_15 = Lateral 
   predefinedEntry_17 = Prox 
   predefinedEntry_19= Mid  
   predefinedEntry_21= Dist 
   predefinedEntry_23 = Upper 
   predefinedEntry_25 = Lower 
   predefinedEntry_27 = RUQ
   predefinedEntry_29 = RLQ 
   predefinedEntry_31 = Supine
   predefinedEntry_2 = Rt Kidney 
   predefinedEntry_4 = Lt Kidney 
   predefinedEntry_6 = Renal Pelvis
   predefinedEntry_8 = Adrenal
   predefinedEntry_10 = Renal Artery
   predefinedEntry_12 = Renal Vein 
   predefinedEntry_14 = Ureter
   predefinedEntry_16 = Bladder
   predefinedEntry_18 = Aorta
   predefinedEntry_20 = IVC
   predefinedEntry_22 = Liver
   predefinedEntry_24 = Spleen
   predefinedEntry_26= Bowel
   predefinedEntry_28 = LUQ 
   predefinedEntry_30 = LLQ 
   predefinedEntry_32 = Prone 
   bodymarks          = ABD

[ScrotalMenu]
    __restitle__     = Scrotal annotation texts
   predefinedEntry_1 = Right
   predefinedEntry_3 = Left 
   predefinedEntry_5 = Sag  
   predefinedEntry_7 = Trans
   predefinedEntry_9 = Prox 
   predefinedEntry_11 = Mid  
   predefinedEntry_13 = Dist 
   predefinedEntry_15 = Upper
   predefinedEntry_17 = Lower
   predefinedEntry_19 = Medial  
   predefinedEntry_21 = Lateral 
   predefinedEntry_23 = Hernia
   predefinedEntry_2 = Testicle
   predefinedEntry_4 = Sperm Cord
   predefinedEntry_6 = Hydrocele
   predefinedEntry_8 = Epididymis
   predefinedEntry_10 = Body 
   predefinedEntry_12 = Head    
   predefinedEntry_14 = Tail 
   predefinedEntry_16 = Spermatocele
   predefinedEntry_18 = Varicocele
   predefinedEntry_20= Mediastinum
   predefinedEntry_22 = Fluid
   predefinedEntry_24 = Bowel  
   bodymarks          = SMLP

[ShoulderMenu]
    __restitle__     = Shoulder annotation texts
   predefinedEntry_1 = Right   
   predefinedEntry_2 = Left    
   predefinedEntry_3 = Sag  
   predefinedEntry_4 = Trans
   predefinedEntry_5 = Prox 
   predefinedEntry_6 = Mid  
   predefinedEntry_7 = Dist 
   predefinedEntry_8 = IST
   predefinedEntry_9 = TM
   predefinedEntry_10 = ACJ
   predefinedEntry_11 = Notch
   predefinedEntry_12 = Labrum
   predefinedEntry_13 = SST
   predefinedEntry_14 = BT
   predefinedEntry_15 = Anatomical Neck
   predefinedEntry_16 = Humeral Head
   predefinedEntry_17 = Grt
   predefinedEntry_18 = Lrt
   predefinedEntry_19 = SC
   bodymarks          = MSCL

[SmallPartsMenu]
    __restitle__          = SmallParts annotation texts
    predefinedEntry_1     = Breast
    predefinedEntry_2     = Thyroid
    predefinedEntry_3     = Testis
    predefinedEntry_4     = Epididymis
    predefinedEntry_5     = Penis
    predefinedEntry_6     = Eye
    predefinedEntry_7     = Right
    predefinedEntry_8     = Left
    bodymarks             = SMLP

[SmallParts_1Menu]
   __restitle__     = SmallParts annotation texts
   predefinedEntry_1 = Right 
   predefinedEntry_2 = Left  
   predefinedEntry_3 = Sag 
   predefinedEntry_4= Trans
   predefinedEntry_5 = Medial    
   predefinedEntry_6 = Lateral   
   predefinedEntry_7 = Upper   
   predefinedEntry_8 = Lower 
   predefinedEntry_9 = Anterior  
   predefinedEntry_10 = Posterior 
   predefinedEntry_11 = Prox  
   predefinedEntry_12 = Mid   
   predefinedEntry_13 = Dist  
   predefinedEntry_14 = Fluid
   predefinedEntry_15 = Bowel
   predefinedEntry_16 = Appendix
   bodymarks          = SMLP

[TCDMenu]
    __restitle__     = TCD annotation texts
   predefinedEntry_1 = Right
   predefinedEntry_3 = Left 
   predefinedEntry_5 = Sag   
   predefinedEntry_7 = Trans 
   predefinedEntry_9 = Prox  
   predefinedEntry_11 = Mid   
   predefinedEntry_13 = Dist  
   predefinedEntry_15 = Upper  
   predefinedEntry_17 = Lower  
   predefinedEntry_19 = Axial   
   predefinedEntry_21 = Coronal
   predefinedEntry_23 = Artery 
   predefinedEntry_24 = Vein   
   predefinedEntry_28 = Stenosis
   predefinedEntry_2 = ICA
   predefinedEntry_4 = MCA
   predefinedEntry_6 = PCA
   predefinedEntry_8 = AComA
   predefinedEntry_10 = PComA
   predefinedEntry_12 = BA
   predefinedEntry_14 = Vert
   predefinedEntry_16 = PICA
   predefinedEntry_18 = OA
   predefinedEntry_20 = Circle Of Willis
   predefinedEntry_22 = Thalami
   predefinedEntry_25 = Anast
   predefinedEntry_26 = Aneurysm 
   predefinedEntry_27 = Graft
   bodymarks          = VASC

 
# related to transcranial which was an old Vingmed annotation package 
#    predefinedEntry_2     = ACA
#    predefinedEntry_6     = ICASiphon
#    predefinedEntry_7     = Basilar
#    predefinedEntry_8     = Vertebral
#    predefinedEntry_9     = Opthalmic
#    predefinedEntry_10    = Artery
#    predefinedEntry_11    = Vein
 
   
[ThyroidMenu]
    __restitle__     = Thyroid annotation texts
   predefinedEntry_1 = Right
   predefinedEntry_3 = Rt Lobe 
   predefinedEntry_5 = Lt Lobe
   predefinedEntry_7 = Sag 
   predefinedEntry_9 = Medial   
   predefinedEntry_11 = Lateral
   predefinedEntry_13 = Prox
   predefinedEntry_15 = Mid 
   predefinedEntry_17 = Dist
   predefinedEntry_2 = Left 
   predefinedEntry_4 = Thyroid
   predefinedEntry_6 = Thyroid
   predefinedEntry_8 = Trans
   predefinedEntry_10= Upper 
   predefinedEntry_12 = Lower
   predefinedEntry_14 = Isthmus 
   predefinedEntry_16 = Trachea
   predefinedEntry_18 = Node
   predefinedEntry_19 = Submand Gland
   predefinedEntry_20= Nodule
   predefinedEntry_21 = Carotid
   predefinedEntry_22 = IJV
   bodymarks          = SMLP
   
[TransplantMenu]
    __restitle__     = Transplant annotation texts
   predefinedEntry_1 = Rt Kidney   
   predefinedEntry_3 = Lt Kidney 
   predefinedEntry_5 = Right
   predefinedEntry_7 = Left 
   predefinedEntry_9 = Sag   
   predefinedEntry_11 = Trans 
   predefinedEntry_13 = Prox 
   predefinedEntry_15= Mid  
   predefinedEntry_17 = Dist 
   predefinedEntry_19 = Upper   
   predefinedEntry_21 = Lower 
   predefinedEntry_23 = Fluid  
   predefinedEntry_2 = Artery
   predefinedEntry_4 = Vein  
   predefinedEntry_6 = Stenosis
   predefinedEntry_8 = Anast
   predefinedEntry_10 = Liver
   predefinedEntry_12 = Pancreas
   predefinedEntry_14 = Renal Pelvis
   predefinedEntry_16 = Ureter
   predefinedEntry_18 = Iliac A
   predefinedEntry_20 = Renal Artery
   predefinedEntry_22 = Renal Vein 
   bodymarks          = MSCL
    
    
[UEAMenu]
    __restitle__     = UEA annotation texts
   predefinedEntry_1 = Right
   predefinedEntry_3 = Left 
   predefinedEntry_5 = Prox 
   predefinedEntry_7 = Mid  
   predefinedEntry_9 = Dist 
   predefinedEntry_11 = Upper 
   predefinedEntry_13 = Lower 
   predefinedEntry_15 = Artery
   predefinedEntry_17 = Vein  
   predefinedEntry_19 = Stenosis
   predefinedEntry_21 = Graft
   predefinedEntry_23 = Anast
   predefinedEntry_25 = Aneurysm
   predefinedEntry_27 = Sag  
   predefinedEntry_29 = Trans
   predefinedEntry_2 = CCA
   predefinedEntry_4 = Aortic Arch
   predefinedEntry_6 = Subc
   predefinedEntry_8 = Innom
   predefinedEntry_10 = Axillary
   predefinedEntry_12 = Brachial
   predefinedEntry_14 = Radial
   predefinedEntry_16 = Ulnar
   predefinedEntry_18 = Digital
   predefinedEntry_20 = In Mamm
   predefinedEntry_22 = Vert
   predefinedEntry_24 = Sup Palmar
   predefinedEntry_26 = Deep Palmar
   predefinedEntry_28 = Metac
   predefinedEntry_30 = Coll
   bodymarks          = VASC
   
[UEVMenu]
    __restitle__     = UEV annotation texts
   predefinedEntry_1 = w/Comp    
   predefinedEntry_2 = Right
   predefinedEntry_4 = Left 
   predefinedEntry_6 = Augment
   predefinedEntry_8 = Prox 
   predefinedEntry_10 = Mid  
   predefinedEntry_12 = Dist 
   predefinedEntry_14 = Upper 
   predefinedEntry_16 = Lower 
   predefinedEntry_18 = Artery
   predefinedEntry_20 = Vein
   predefinedEntry_22 = Stenosis
   predefinedEntry_24 = Graft
   predefinedEntry_26 = Anast
   predefinedEntry_28 = Aneurysm
   predefinedEntry_30 = Cephalic
   predefinedEntry_3= Sag  
   predefinedEntry_5 = Trans
   predefinedEntry_7 = IJV
   predefinedEntry_9 = Innom V
   predefinedEntry_11 = Subcl V
   predefinedEntry_13 = Axill V
   predefinedEntry_15 = Brachial V
   predefinedEntry_17 = M Cub V
   predefinedEntry_19 = Ulnar V
   predefinedEntry_21 = Radial V 
   predefinedEntry_23 = Sup Palmar
   predefinedEntry_25 = Deep Palmar
   predefinedEntry_27 = Digital
   predefinedEntry_29 = SVC
   predefinedEntry_31 = Basilic
   bodymarks = VASC

   
[WristMenu]
    __restitle__     = Wrist annotation texts
   predefinedEntry_1 = Right
   predefinedEntry_2 = Left 
   predefinedEntry_3 = Sag   
   predefinedEntry_4 = Trans 
   predefinedEntry_5 = Prox  
   predefinedEntry_6 = Mid   
   predefinedEntry_7 = Dist  
   predefinedEntry_8 = Upper 
   predefinedEntry_9 = Lower 
   predefinedEntry_10 = MN
   predefinedEntry_11 = Compartment
   predefinedEntry_12 = Radius
   predefinedEntry_13 = Ulna
   bodymarks          = MSCL

# Body patterns 

[ABDBodyMark]
   bodymarkBitmap_1 = body1
   bodymarkBitmap_2 = body2
   bodymarkBitmap_3 = liver
   bodymarkBitmap_4 = organ4
   bodymarkBitmap_5 = body5
   bodymarkBitmap_6 = body4
   bodymarkBitmap_7 = organ1
   bodymarkBitmap_8 = organ5
   bodymarkBitmap_9 = body6
   bodymarkBitmap_10 = body3
   bodymarkBitmap_11 = organ2
   bodymarkBitmap_12 = pelvis1
   bodymarkBitmap_13 = breast3
   bodymarkBitmap_14 = organ3
   bodymarkBitmap_15 = pelvis2
   bodymarkBitmap_16 = organ6
   bodymarkBitmap_17 = organ7
   bodymarkBitmap_18 = organ9

[CARDBodyMark]
   bodymarkBitmap_1 = abdo5
   bodymarkBitmap_2 = abdo6
   bodymarkBitmap_3 = body7
   bodymarkBitmap_4 = body8
   bodymarkBitmap_5 = chest3
   bodymarkBitmap_6 = heart1
   bodymarkBitmap_7 = heart5
   bodymarkBitmap_8 = heart2
   bodymarkBitmap_9 = heart6
   bodymarkBitmap_10 = heart3
   bodymarkBitmap_11 = heart7
   bodymarkBitmap_12 = heart4
   bodymarkBitmap_13 = heart8

[GYNBodyMark]
   bodymarkBitmap_1 = pelvis2
   bodymarkBitmap_2 = uterus1
   bodymarkBitmap_3 = breast3
   bodymarkBitmap_4 = organ5
   bodymarkBitmap_5 = uterus2
   bodymarkBitmap_6 = pelvis1
   bodymarkBitmap_7 = uterus3

[MSCLBodyMark]
   bodymarkBitmap_1 = legs1
   bodymarkBitmap_2 = legs4
   bodymarkBitmap_3 = arm1
   bodymarkBitmap_4 = arm5
   bodymarkBitmap_5 = legs2
   bodymarkBitmap_6 = legs5
   bodymarkBitmap_7 = arm2
   bodymarkBitmap_8 = arm6
   bodymarkBitmap_9 = legs3
   bodymarkBitmap_10 = legs6
   bodymarkBitmap_11 = arm3
   bodymarkBitmap_12 = hand1
   bodymarkBitmap_13 = arm4
   bodymarkBitmap_14 = hand2

[OBBodyMark]
   bodymarkBitmap_1 = pelvis2
   bodymarkBitmap_2 = fetus11
   bodymarkBitmap_3 = ob2
   bodymarkBitmap_4 = uterus1
   bodymarkBitmap_5 = breast3
   bodymarkBitmap_6 = ob1
   bodymarkBitmap_7 = fetus05
   bodymarkBitmap_8 = uterus2
   bodymarkBitmap_9 = ob4
   bodymarkBitmap_10 = fetus01
   bodymarkBitmap_11 = fetus02
   bodymarkBitmap_12 = fetus03
   bodymarkBitmap_13 = fetus15
   bodymarkBitmap_14 = fetus06
   bodymarkBitmap_15 = fetus07

[PEDBodyMark]
   bodymarkBitmap_1 = body1
   bodymarkBitmap_2 = body2
   bodymarkBitmap_3 = organ1
   bodymarkBitmap_4 = head1
   bodymarkBitmap_5 = body5
   bodymarkBitmap_6 = body4
   bodymarkBitmap_7 = organ2
   bodymarkBitmap_8 = head2
   bodymarkBitmap_9 = body6
   bodymarkBitmap_10 = body3
   bodymarkBitmap_11 = organ3
   bodymarkBitmap_12 = head3
   bodymarkBitmap_13 = liver
   bodymarkBitmap_14 = organ4
   bodymarkBitmap_15 = head4

[SMLPBodyMark]
   bodymarkBitmap_1 = neck1 
   bodymarkBitmap_2 = neck4 
   bodymarkBitmap_3 = breast3
   bodymarkBitmap_4 = neck2  
   bodymarkBitmap_5 = thyroid
   bodymarkBitmap_6 = breast1
   bodymarkBitmap_7 = neck3
   bodymarkBitmap_8 = breast2

[TWINBodyMark]
   bodymarkBitmap_1 = twin1
   bodymarkBitmap_2 = twin5
   bodymarkBitmap_3 = twin2
   bodymarkBitmap_4 = twin6
   bodymarkBitmap_5 = twin3 
   bodymarkBitmap_6 = twin7
   bodymarkBitmap_7 = twin4
   bodymarkBitmap_8 = twin8

[UROBodyMark]
   bodymarkBitmap_1 = body1
   bodymarkBitmap_2 = uro1
   bodymarkBitmap_3 = uro5
   bodymarkBitmap_4 = body5
   bodymarkBitmap_5 = uro2 
   bodymarkBitmap_6 = uro6 
   bodymarkBitmap_7 = body6
   bodymarkBitmap_8 = uro3
   bodymarkBitmap_9 = uro7
   bodymarkBitmap_10 = uro4
   bodymarkBitmap_11 = uro8

[VASCBodyMark]
   bodymarkBitmap_1 = neck1 
   bodymarkBitmap_2 = arm6 
   bodymarkBitmap_3 = legs1
   bodymarkBitmap_4 = head5
   bodymarkBitmap_5 = neck2
   bodymarkBitmap_6 = arm3
   bodymarkBitmap_7 = legs2
   bodymarkBitmap_8 = head4
   bodymarkBitmap_9 = neck3
   bodymarkBitmap_10 = arm4
   bodymarkBitmap_11 = legs5
   bodymarkBitmap_12 = head3
   bodymarkBitmap_13 = arm5
   bodymarkBitmap_14 = legs6
   bodymarkBitmap_15 = head2
   bodymarkBitmap_16 = legs3
   bodymarkBitmap_17 = legs4


