#!/bin/bash

# This script will help you install dcm4chee-arc-light and related software
# Please read through the script first and customize it

# ============ Customize this part ====================

MYSQLROOTPW=radiologija                       # MySQL root password
PACSUSER=radiologija                          # Desired user that will run the server
PACSUSERPASSW=radiologija123                  # users UNIX password
PACSDB=pacsdb                               # MySQL database for dcm4chee-arc-light
DBUSER=pacs                                 # MySQL user 
DBPASS=pacs                                 # MySQL password
AET=PACS1                                   # dcm4chee-arc-light AET
ETHINTERFACE=enp0s3                         # Main ethernet interface for the server
INSTALLDIR=/opt                             # Where to create the installation directory
DCM4CHEEDIR=$INSTALLDIR/dcm4chee-arc-light  # Installation directory
INSTALLOG=/tmp/dcm4chee-install.log         # Log file for installation
DOWNLOADSDIR=./Downloads                    # Directory to store downloaded files
# Variables for LDAP install, if not changed will use the server FQDN
#SERVER=$(hostname --fqdn)   # something like: server1.example.com
#DOMAIN=${SERVER#*.}         # something like: example.com
#REALM=$(echo "${DOMAIN}" | tr '[:lower:]' '[:upper:]')   # something like: EXAMPLE.COM
#LDAPROOT=`echo $DOMAIN | sed -e 's/^/dc=/' -e 's/\./\,dc=/'`
LDAPSERVER="ubuntu1.dcm4che.org"
LDAPDOMAIN="dcm4che.org" 
LDAPREALM="DCM4CHE.ORG" 
LDAPROOT="dc=dcm4che,dc=org"
LDAPADMINPW=radiologija123

# ============ End of Configuration part ==============

# Colors
SR="\e[31m"
SY="\e[33m"
SG="\e[32m"
SD="\e[39m"

STARTDIR=`pwd`
WILDFLYDIR=$DCM4CHEEDIR/wildfly
APTINSTALL="apt-get --assume-yes -qq install"
WGET="wget -q --show-progress"

# Verify we are runing as root
if [ "$EUID" -ne 0 ]
  then echo -e "\n $SY Please run as root or with sudo $SD \n"
  exit
fi

# Verify MySQL root password
if [ -e "/usr/bin/mysql" ]
then
    if ! mysql -uroot -p"$MYSQLROOTPW" -e ";" 2> /dev/null
    then
        echo -e "\n $SY Warning! The MySQL root password is not working, please check the config $SD"
        exit
    fi
fi

# Create a directory for downloading files
if [ -e "./$DOWNLOADSDIR" ]
then
    echo -e "\n $SY Directory $DOWNLOADSDIR already exists, skipping creation $SD"
else
    mkdir $DOWNLOADSDIR
fi

# Create the dcm4chee user
if getent passwd $PACSUSER > /dev/null 2>&1; then
    echo -e "\n $SY The user $PACSUSER already exists, skipping creation .. $SD"
else
    echo -e "\n $SG Creating user $PACSUSER $SD"
    sudo groupadd $PACSUSER
    sudo useradd -p $(echo "$PACSUSERPASSW" | openssl passwd -1 -stdin) -d /home/"$PACSUSER" -m -g "$PACSUSER" -s /bin/bash "$PACSUSER"
fi

# Get the IP address of the interface it's going to be used for the server
ETHFOUND=`grep "$ETHINTERFACE" /proc/net/dev`
if [ -n "$ETHFOUND" ]
then
    IPADDR=`ifconfig $ETHINTERFACE | awk '/inet addr/{print substr($2,6)}'`
else
    echo -e "\n $SY Could not find network interface $ETHINTERFACE, please add correct interface in the Configuration part of this script\n $SD"
    exit
fi

# LDAP requires the ROOTDN to match the server FQDN
FQDN=`hostname --fqdn`
if [ "$FQDN" != "$LDAPSERVER" ]
then
    echo -e "\n $SY Warning! Please edit /etc/hosts to reflect the server FQDN name $LDAPSERVER or change the LDAPSERVER config variable $SD"
    echo "      FQDN = $FQDN"
    echo "LDAPSERVER = $FQDN"
    exit
fi


#### Delete old instance of dcm4chee ####

echo -e "\n $SR Warning!! Warning!! This script will now remove all previous install dirs, drop database in MySQL and LDAP"
echo -e " $SR Warning!! Press Enter to continue or Ctrl-C to abort $SD "
read dummy
echo -e "    Warning!! Shutting down running instance"
$WILDFLYDIR/bin/jboss-cli.sh --connect command=:shutdown  2>&1 > $INSTALLOG
sleep 5
for p in `ps -ef | grep wildfly | awk '{print $2}' | tr '\n' ' '`
do
    kill -9 $p >> $INSTALLOG 2>&1
done

echo -e "    Warning!! Dropping $PACSDB database"
mysqladmin -p"$MYSQLROOTPW" -f drop $PACSDB >> $INSTALLOG 2>&1
echo -e "    Warning!! Removing install dirs"
rm $DCM4CHEEDIR
rm -rf $INSTALLDIR/dcm4chee* >> $INSTALLOG 2>&1
echo -e "    Warning!! Removing LDAP"
/etc/init.d/slapd stop
apt-get --assume-yes -qq purge slapd ldap-utils >> $INSTALLOG 2>&1
rm -rf /var/lib/ldap/ >> $INSTALLOG 2>&1
rm -rf /etc/ldap >> $INSTALLOG 2>&1


#### Install OS software dependencies ####

echo -e "\n $SG Installing OS software dependencies... $SD"
if [ -e "/usr/bin/unzip" ]; then
    echo -e " $SY Zip utilities already installed, skipping... $SD"
else 
    echo -e " $SG Zip utilities not installed, installing... $SD"
    $APTINSTALL zip > /dev/null
fi


if [ -e "/usr/bin/java" ]; then
    JAVAVERSION=`java -version 2>&1 | head -1 | sed -e 's/^.* \"//' -e 's/\./____/2' -e 's/____.*//'`
    if [[ "$JAVAVERSION" > "1.7" ]]
    then
        echo -e " $SY Java already installed, skipping... $SD"
    else
        echo -e " $SR Java is version $JAVAVERSION. Please install java 8, exiting $SD"
        exit 1
    fi
else 
    echo -e " $SG Java not installed, installing... $SD"
    $APTINSTALL --no-install-recommends default-jre > /dev/null
fi 

if [ -e "/usr/bin/lynx" ]; then
    echo -e " $SY Lynx already installed, skipping... $SD"
else
    echo -e " $SG Lynx not installed, installing... $SD"
    $APTINSTALL lynx > /dev/null
fi

if [ -e "/usr/bin/mysql" ]; then
    echo -e " $SY MySQL already installed, skipping... $SD"
else
    echo -e " $SG MySQL not installed, installing... $SD"
    DEBIAN_FRONTEND=noninteractive $APTINSTALL mysql-server > /dev/null
    #$APTINSTALL mysql-server > /dev/null
    mysqladmin -u root password "$MYSQLROOTPW"
fi

if [ -e "/usr/share/java/mysql-connector-java.jar" ]; then
    echo -e " $SY MySQL JAVA connector already installed, skipping... $SD"
else
    echo -e " $SG MySQL JAVA connector not installed, installing... $SD"
    $APTINSTALL libmysql-java > /dev/null
fi

#echo -e "\n $SG LDAP will be installed with the following parameters $SD"
#echo -e "\nLDAPSERVER:   $SERVER \nLDAPDOMAIN:   $DOMAIN \nLDAPREALM:    $REALM \nLDAPROOT: $LDAPROOT \n"

if [ -e "/usr/sbin/slapd" ]; then
    echo -e " $SY OpenLDAP already installed, skipping... $SD"
else
    echo -e " $SG OpenLDAP not installed, installing... $SD"
    DEBIAN_FRONTEND=noninteractive $APTINSTALL slapd ldap-utils > /dev/null
fi


#### Download dcm4chee-arc-light and related software ####

cd $DOWNLOADSDIR
# Find latest version available of dcm4chee arc light #
echo -ne "\n $SG Looking for latest version of dcm4chee arc light... $SD"
DCMARCVER=`lynx -dump https://sourceforge.net/projects/dcm4che/files/dcm4chee-arc-light5/ | grep files | grep -v timeline | grep 5. | sed -e 's/^.*dcm4chee-arc-light5\///' -e 's/\/.*//' | head -1`
#DCMARCVER="5.10.1"
echo -e "(Found dcm4chee-arc-light $DCMARCVER)"
DCMARCURL=`lynx -dump https://sourceforge.net/projects/dcm4che/files/dcm4chee-arc-light5/$DCMARCVER/ | grep mysql.zip | grep download | sed -e 's/^.*https/https/'`

# Install dcm4chee-arc-light
if [ -e "dcm4chee-arc-$DCMARCVER-mysql.zip" ]; then
    echo -e " $SY dcm4chee already downloaded, skipping download... $SD"
    echo -e "  Unpacking dcm4chee dcm4chee-arc-light $DCMARCVER ..."
    unzip -q dcm4chee-arc-$DCMARCVER-mysql.zip
    mv dcm4chee-arc-$DCMARCVER-mysql $INSTALLDIR/
    ln -s $INSTALLDIR/dcm4chee-arc-$DCMARCVER-mysql $INSTALLDIR/dcm4chee-arc-light
else
    echo -e " $SG Downloading dcm4chee-arc-light $DCMARCVER ... $SD"
    $WGET $DCMARCURL
    mv download dcm4chee-arc-$DCMARCVER-mysql.zip
    echo -e "  Unpacking dcm4chee dcm4chee-arc-light $DCMARCVER ..."
    unzip -q dcm4chee-arc-$DCMARCVER-mysql.zip
    mv dcm4chee-arc-$DCMARCVER-mysql $INSTALLDIR/
    ln -s $INSTALLDIR/dcm4chee-arc-$DCMARCVER-mysql $INSTALLDIR/dcm4chee-arc-light
fi

# If you wish to install ApacheDirectoryStudio, uncomment below
#if [ -e "ApacheDirectoryStudio-2.0.0.v20161101-M12-linux.gtk.x86_64.tar.gz" ]; then
#    echo -e "\n $SY ADS already downloaded, skipping download... $SD"
#    echo -e "Unpacking ADS..."
#    tar -xzf ApacheDirectoryStudio-2.0.0.v20161101-M12-linux.gtk.x86_64.tar.gz
#    mv ApacheDirectoryStudio $DCM4CHEEDIR/
#else
#    echo -e "\n $SG Downloading Apache Directory Studio... $SD"
#    $WGET http://ftp.carnet.hr/misc/apache/directory/studio/2.0.0.v20161101-M12/ApacheDirectoryStudio-2.0.0.v20161101-M12-linux.gtk.x86_64.tar.gz
#    echo -e "Unpacking ADS..."
#    tar -xzf ApacheDirectoryStudio-2.0.0.v20161101-M12-linux.gtk.x86_64.tar.gz
#    mv ApacheDirectoryStudio $DCM4CHEEDIR/
#fi

# Install Wildfly 10.1.0
if [ -e "wildfly-10.1.0.Final.tar.gz" ]; then
    echo -e "\n $SY Wildfly already downloaded, skipping download... $SD"
    echo -e "  Unpacking Wildfly..."
    tar -xzf wildfly-10.1.0.Final.tar.gz
    mv wildfly-10.1.0.Final $DCM4CHEEDIR/
    ln -s $DCM4CHEEDIR/wildfly-10.1.0.Final $DCM4CHEEDIR/wildfly
else
    echo -e "\n $SG Downloading WildFly 10.1.0... $SD"
    $WGET http://download.jboss.org/wildfly/10.1.0.Final/wildfly-10.1.0.Final.tar.gz
    echo -e "  Unpacking Wildfly..."
    tar -xzf wildfly-10.1.0.Final.tar.gz
    mv wildfly-10.1.0.Final $DCM4CHEEDIR/
    ln -s $DCM4CHEEDIR/wildfly-10.1.0.Final $DCM4CHEEDIR/wildfly
fi

# Find latest version available for weasis #
echo -ne "\n $SG Looking for latest version of Weasis download... $SD"
WEASISVER=`lynx -dump https://sourceforge.net/projects/dcm4che/files/Weasis/ | grep files | grep -v timeline | grep Weasis | grep -v connector |  grep -v web | sed -e 's/^.*Weasis\///' -e 's/\/.*//' |head -1`
#WEASISVER="2.5.2"
echo -e "(Found Weasis $WEASISVER)"

# Install Weasis
if [ -e "weasis.war" ]; then
    echo -e "$SY  Weasis already downloaded, skipping download... $SD"
    echo -e "  Installing Weasis $WEASISVER"
    #cp weasis.war $WILDFLYDIR/standalone/deployments/
    cp weasis.war $DCM4CHEEDIR/deploy/
    echo -e "$SG  Downloading latest version of weasis.ldif $SD"
    rm weasis.ldif
    $WGET "https://dcm4che.atlassian.net/wiki/download/attachments/3670023/weasis.ldif"
else
    echo -e "$SG  Downloading Weasis $WEASISVER ... $SD"
    $WGET https://sourceforge.net/projects/dcm4che/files/Weasis/$WEASISVER/weasis.war/download
    mv download weasis.war
    echo -e "  Installing Weasis $WEASISVER"
    #cp weasis.war $WILDFLYDIR/standalone/deployments/
    cp weasis.war $DCM4CHEEDIR/deploy/
    echo -e "$SG Downloading latest version of weasis.ldif $SG"
    rm weasis.ldif
    $WGET "https://dcm4che.atlassian.net/wiki/download/attachments/3670023/weasis.ldif"
fi

# If you wish to install dcm4che2 utils, uncomment below
#if [ -e "dcm4che-2.0.29-bin.zip" ]; then
#    echo -e "\n $SY dcm4che2 tools already  downloaded, skipping download... $SD"
#    echo -e "  Installing dcm4che 2 tools"
#    unzip -q dcm4che-2.0.29-bin.zip
#    mv dcm4che-2.0.29 $DCM4CHEEDIR/
#else
#    echo -e "$SG Downloading dcm4che2 tools... $SD"
#    $WGET https://sourceforge.net/projects/dcm4che/files/dcm4che2/2.0.29/dcm4che-2.0.29-bin.zip/download
#    mv download dcm4che-2.0.29-bin.zip
#    echo -e "  Installing dcm4che 2 tools"
#    unzip -q dcm4che-2.0.29-bin.zip
#    mv dcm4che-2.0.29 $DCM4CHEEDIR/
#fi


# Find latest version available for weasis-pacs-connector #
echo -ne "\n $SG Looking for latest version of weasis-pacs-connector ... $SD"
PACSCONVER=`lynx -dump https://sourceforge.net/projects/dcm4che/files/Weasis/weasis-pacs-connector/ | grep weasis-pacs-connector | grep files | grep Weasis | sed -e 's/^.*weasis-pacs-connector\///' -e 's/\/.*//' |head -1`
echo -e "(Found weasis-pacs-connector $PACSCONVER)"

# Install weasis-pacs-connector
if [ -e "weasis-pacs-connector.war" ]; then
    echo -e " $SY Weasis pacs connector already downloaded, skipping download... $SD"
    #echo "Installing Weasis pacs connector $PACSCONVER"
    #echo -e "  Copying weasis-pacs-connector.war to $DCM4CHEEDIR/deploy/"
    #cp weasis-pacs-connector.war $WILDFLYDIR/standalone/deployments/
    cp weasis-pacs-connector.war $DCM4CHEEDIR/deploy/
else
    echo -e "$SG Downloading Weasis pacs connector $PACSCONVER ... $SD"
    $WGET https://sourceforge.net/projects/dcm4che/files/Weasis/weasis-pacs-connector/$PACSCONVER/weasis-pacs-connector.war/download
    mv download weasis-pacs-connector.war
    #echo "Installing Weasis pacs connector $PACSCONVER"
    #echo -e "Copying weasis-pacs-connector.war to $DCM4CHEEDIR/deploy/"
    #cp weasis-pacs-connector.war $WILDFLYDIR/standalone/deployments/
    cp weasis-pacs-connector.war $DCM4CHEEDIR/deploy/
fi


### Install and configure ###


echo -e "\n $SG Configuring Weasis pacs connector $PACSCONVER $SD"
rm dicom-dcm4chee.properties
$WGET https://raw.githubusercontent.com/nroduit/weasis-pacs-connector/master/src/main/resources/dicom-dcm4chee.properties
cat dicom-dcm4chee.properties | sed -e 's/arc.wado.url=${server.base.url}\/wado/arc.wado.url=${server.base.url}\/dcm4chee-arc\/aets\/DCM4CHEE\/wado/' -e 's/arc.host=localhost/arc.host='$IPADDR'/' -e 's/DCM4CHEE/'$AET'/g' > $WILDFLYDIR/standalone/configuration/dicom-dcm4chee.properties
$WGET https://raw.githubusercontent.com/nroduit/weasis-pacs-connector/master/src/main/resources/weasis-connector-default.properties
mv weasis-connector-default.properties weasis-pacs-connector.properties
cp weasis-pacs-connector.properties $WILDFLYDIR/standalone/configuration/


#echo -e "\nConverting DCM4CHEE instance to $AET instance.."
#find $DCM4CHEEDIR/ -type f -exec sed -i "s/DCM4CHEE/$AET/g" {} +

echo -e "\n $SG Creating pacsdb database... $SD"
mysqladmin -uroot -p"$MYSQLROOTPW" create $PACSDB >> $INSTALLOG 2>&1

echo "GRANT ALL PRIVILEGES ON \`$PACSDB\` . * TO '$DBUSER'@'localhost' IDENTIFIED BY '$DBPASS' WITH GRANT OPTION ;" > /tmp/dcm4chee_mysql_user
echo -e "  Creating pacs user for pacsdb database..."
mysql -uroot -p"$MYSQLROOTPW" $PACSDB < /tmp/dcm4chee_mysql_user >> $INSTALLOG 2>&1

echo -e "  Populating pacsdb database..."
mysql -u $DBUSER -p"$DBPASS" -h localhost $PACSDB < $DCM4CHEEDIR/sql/create-mysql.sql >> $INSTALLOG 2>&1

# Configure LDAP
echo -e "\n $SG Creating LDAP database... $SD"
cat <<EOF >/etc/ldap/ldap.conf
BASE    ${LDAPROOT}
URI     ldapi://
EOF

echo -n "$LDAPADMINPW" >ldap-admin-pw.txt
chmod 600 ldap-admin-pw.txt
LDAP_ADMIN_HASH=$(slappasswd -h '{SHA}' -T ldap-admin-pw.txt)
cat <<EOF >./newpassword.ldif
dn: olcDatabase={1}mdb,cn=config
changetype: modify
replace: olcRootPW
olcRootPW: "$LDAP_ADMIN_HASH"
EOF
ldapmodify -H ldapi:// -Y EXTERNAL -f ./newpassword.ldif >> $INSTALLOG 2>&1
rm ./newpassword.ldif
rm ldap-admin-pw.txt

echo -e "  Importing LDAP schema files for OpenLDAP runtime configuration"
cd $DCM4CHEEDIR/ldap/
cat <<EOF >modify-baseDN.ldif
dn: olcDatabase={1}mdb,cn=config
changetype: modify
replace: olcSuffix
olcSuffix: ${LDAPROOT}
-
replace: olcRootDN
olcRootDN: cn=admin,${LDAPROOT}
-
EOF
ldapmodify -Y EXTERNAL -H ldapi:/// -f ./modify-baseDN.ldif >> $INSTALLOG 2>&1
#cp init-baseDN.ldif init-baseDN.ldif.orig
cp init-config.ldif init-config.ldif.orig
cp default-config.ldif default-config.ldif.orig
cp add-vendor-data.ldif add-vendor-data.ldif.orig
#sed -i s/dc=dcm4che,dc=org/$LDAPROOT/ init-baseDN.ldif
sed -i s/dc=dcm4che,dc=org/$LDAPROOT/ init-config.ldif
sed -i s/dc=dcm4che,dc=org/$LDAPROOT/ default-config.ldif
sed -i s/dc=dcm4che,dc=org/$LDAPROOT/ add-vendor-data.ldif
ldapadd -Q -Y EXTERNAL -H ldapi:/// -f $DCM4CHEEDIR/ldap/slapd/dicom.ldif >> $INSTALLOG 2>&1
ldapadd -Q -Y EXTERNAL -H ldapi:/// -f $DCM4CHEEDIR/ldap/slapd/dcm4che.ldif >> $INSTALLOG 2>&1
ldapadd -Q -Y EXTERNAL -H ldapi:/// -f $DCM4CHEEDIR/ldap/slapd/dcm4chee-archive.ldif >> $INSTALLOG 2>&1
#ldapadd -x -D cn=admin,$LDAPROOT -w $LDAPADMINPW -f $DCM4CHEEDIR/ldap/init-baseDN.ldif >> $INSTALLOG
ldapadd -x -D cn=admin,$LDAPROOT -w $LDAPADMINPW -f $DCM4CHEEDIR/ldap/init-config.ldif >> $INSTALLOG 2>&1
cp default-config.ldif default-config.ldif.tmp
cat default-config.ldif.tmp | sed -e 's/DCM4CHEE_ADMIN/'$AET'_ADMIN/g' -e 's/DCM4CHEE_TRASH/'$AET'_TRASH/g' -e 's/DCM4CHEE/'$AET'/g' > default-config.ldif
rm default-config.ldif.tmp
ldapadd -x -D cn=admin,$LDAPROOT -w $LDAPADMINPW -f $DCM4CHEEDIR/ldap/default-config.ldif >> $INSTALLOG 2>&1
ldapadd -x -D cn=admin,$LDAPROOT -w $LDAPADMINPW -f $DCM4CHEEDIR/ldap/add-vendor-data.ldif >> $INSTALLOG 2>&1
# Restart LDAP-server
echo -e "  Restarting LDAP"
/etc/init.d/slapd restart

# Configure Wildfly
echo -e "\n $SG Configuring Wildfly... $SD"
cp -r $DCM4CHEEDIR/configuration/dcm4chee-arc $WILDFLYDIR/standalone/configuration
cd $WILDFLYDIR/standalone/configuration
cp standalone-full.xml dcm4chee-arc.xml
cd $WILDFLYDIR
for f in `find $DCM4CHEEDIR/jboss-modules -name *.zip`; do unzip -q $f; done
cp modules/com/mysql/main/module.xml modules/com/mysql/main/module.xml.orig
cat modules/com/mysql/main/module.xml.orig | sed -e 's/<resource-root path=".*/<resource-root path="\/usr\/share\/java\/mysql-connector-java.jar"\/>/' > modules/com/mysql/main/module.xml
cat <<EOF >$DCM4CHEEDIR/cli/add-data-source-mysql.cli
/subsystem=datasources/jdbc-driver=mysql:add(driver-module-name=com.mysql,driver-name=mysql)
data-source add --name=pacsds --driver-name=mysql --jndi-name=java:/PacsDS \
--connection-url=jdbc:mysql://localhost:3306/pacsdb \
--user-name=pacs --password=pacs
EOF
cat <<EOF >$WILDFLYDIR/standalone/configuration/dcm4chee-arc/ldap.properties
java.naming.factory.initial=com.sun.jndi.ldap.LdapCtxFactory
java.naming.ldap.attributes.binary=dicomVendorData
java.naming.provider.url=ldap://localhost:389/$LDAPROOT
java.naming.security.principal=cn=admin,$LDAPROOT
java.naming.security.credentials=$LDAPADMINPW
EOF

# Creating start stop scripts
cat <<EOF >/usr/local/bin/pacs_start.sh
#!/bin/bash
USERID=`id -u $PACSUSER`
if [ "\$EUID" -ne "\$USERID" ]
    then echo -e "\n $SY Please run as user $PACSUSER $SD \n"
    exit
else
    echo -e "\nStarting Wildfly ..."
    $WILDFLYDIR/bin/standalone.sh -b=0.0.0.0 -bmanagement=0.0.0.0 -c dcm4chee-arc.xml >> $WILDFLYDIR/standalone/log/server.log 2>&1 &
    disown
    sleep 10
    echo -e "\nWildfly started, log is in $WILDFLYDIR/standalone/log/server.log"
fi
EOF
chmod +x /usr/local/bin/pacs_start.sh
cat <<EOF >/usr/local/bin/pacs_stop.sh
#!/bin/bash
USERID=`id -u $PACSUSER`
if [ "\$EUID" -ne "\$USERID" ]
    then echo -e "\n $SY Please run as user $PACSUSER $SD \n"
    exit
else
    echo -e "\nStopping Wildfly ..."
    $WILDFLYDIR/bin/jboss-cli.sh --connect command=:shutdown
    sleep 10
    for p in `ps -ef | grep wildfly | awk '{print $2}' | tr '\n' ' '`
    do
        kill -9 $p
    done

fi
EOF
chmod +x /usr/local/bin/pacs_stop.sh

#echo -e "\n $SG Setting permissions on files... $SD"
chown -R $PACSUSER:$PACSUSER $DCM4CHEEDIR/

echo -e "\n $SG Starting Wildfly... $SD"
su - $PACSUSER -c "$WILDFLYDIR/bin/standalone.sh -b=0.0.0.0 -bmanagement=0.0.0.0 -c dcm4chee-arc.xml" >> $INSTALLOG &
sleep 15
echo -e "\n $SG Adding datasource to Wildfly... $SD"
su - $PACSUSER -c "$WILDFLYDIR/bin/jboss-cli.sh -c --file=$DCM4CHEEDIR/cli/add-data-source-mysql.cli" >> $INSTALLOG &
sleep 5
echo -e "\n $SG Adding jms queues to Wildfly... $SD"
su - $PACSUSER -c "$WILDFLYDIR/bin/jboss-cli.sh -c --file=$DCM4CHEEDIR/cli/add-jms-queues.cli" >> $INSTALLOG &
sleep 5
echo -e "\n $SG Deploying dcm4chee-arc-light $DCMARCVER ... $SD"
su - $PACSUSER -c "cp $DCM4CHEEDIR/deploy/dcm4chee-arc-ear-* $WILDFLYDIR/standalone/deployments/" >> $INSTALLOG &
sleep 15
echo -e "\n $SG Deploying Weasis $WEASISVER ... $SD"
sed -i s/dc=dcm4che,dc=org/$LDAPROOT/ $STARTDIR/$DOWNLOADSDIR/weasis.ldif
ldapadd -x -D cn=admin,$LDAPROOT -w $LDAPADMINPW -f $STARTDIR/$DOWNLOADSDIR/weasis.ldif
su - $PACSUSER -c "cp $DCM4CHEEDIR/deploy/weasis.war $WILDFLYDIR/standalone/deployments/" >> $INSTALLOG &
sleep 5
echo -e "\n $SG Deploying Weasis pacs connector ... $SD"
su - $PACSUSER -c "cp $DCM4CHEEDIR/deploy/weasis-pacs-connector.war $WILDFLYDIR/standalone/deployments/" >> $INSTALLOG &
sleep 5
echo -e "\n $SG Restarting wildfly $SD"
su - $PACSUSER -c "/usr/local/bin/pacs_stop.sh" 2> /dev/null
su - $PACSUSER -c "/usr/local/bin/pacs_start.sh" 2> /dev/null


echo -e "\n\n $SG ######### Installation complete ######### $SD"

echo -e "\nThe installed instance should be already running, please test"
echo -e "\nTo stop wildfly, run as $PACSUSER with:"
echo -e "/usr/local/bin/pacs_stop.sh"

echo -e "\nTo start wildfly, run as $PACSUSER with:"
echo "/usr/local/bin/pacs_start.sh"

echo -e "\nTo access the web interface go to:  http://$IPADDR:8080/dcm4chee-arc/ui"

